﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Samples.ServiceHosting.StorageClient;
using ProAzureTableStorageClasses;
using System.Data.Services.Client;
using ProAzureCommonLib;

namespace ProAzureReaderTracker_WebRole
{
 public partial class TableOperations : System.Web.UI.Page
 {
  protected void Page_Load(object sender, EventArgs e)
  {
   if (!this.IsPostBack)
   {
    ListTables();
   }
  }

  protected void btnCreateTable_Click(object sender, EventArgs e)
  {
   CreateTable();
  }

  protected void btnDeleteTable_Click(object sender, EventArgs e)
  {
   DeleteTable();
  }

  private void CreateTable()
  {

   string statusMessage = String.Empty;

   if (txtCreateTable.Text.Length > 0)
   {
    try
    {

     WindowsAzureStorageHelper storageHelper = new WindowsAzureStorageHelper();
     storageHelper.CreateTable(txtCreateTable.Text);
     statusMessage = "Table created successfully.";
     ListTables();

    }
    catch (DataServiceRequestException ex)
    {
     statusMessage = "Unable to connect to the table storage server. Please check that the service is running.<br>"
                     + ex.Message;
    }
   }
   else
   {
    statusMessage = "Please enter a table name.";
   }
   lblStatus.Text = statusMessage;

  }

  private void CreateProAzureTable()
  {

   string statusMessage = String.Empty;
   try
   {
    StorageAccountInfo accountInfo = StorageAccountInfo.GetAccountInfoFromConfiguration("TableStorageEndpoint");

    // dynamically create the tables
    ProAzureReaderDataSource.CreateTable(accountInfo);
    statusMessage = "Table created successfully.";
    ListTables();

    }
    catch (DataServiceRequestException ex)
    {
     statusMessage = "Unable to connect to the table storage server. Please check that the service is running.<br>"
                     + ex.Message;
    } 

   lblStatus.Text = statusMessage;

  }

  private void DeleteProAzureTable()
  {
   string statusMessage = String.Empty;
   try
   {
    StorageAccountInfo accountInfo = StorageAccountInfo.GetAccountInfoFromConfiguration("TableStorageEndpoint");

    ProAzureReaderDataSource.DeleteTable(ProAzureReaderDataSource.ENTITY_SET_NAME, accountInfo);
    statusMessage = "Table deleted successfully.";
    ListTables();
   }
   catch (DataServiceRequestException ex)
   {
    statusMessage = "Unable to connect to the table storage server. Please check that the service is running.<br>"
                    + ex.Message;
   }

   lblStatus.Text = statusMessage;
  }

  private void DeleteTable()
  {

   string statusMessage = String.Empty;

   if (txtDeleteTable.Text.Length > 0)
   {
    try
    {

     WindowsAzureStorageHelper storageHelper = new WindowsAzureStorageHelper();
     storageHelper.DeleteTable(txtDeleteTable.Text);
     statusMessage = "Table deleted successfully.";
     ListTables();

    }
    catch (DataServiceRequestException ex)
    {
     statusMessage = "Unable to connect to the table storage server. Please check that the service is running.<br>"
                     + ex.Message;
    }
   }
   else
   {
    statusMessage = "Please select a table name to delete.";
   }
   lblStatus.Text = statusMessage;

  }

  private void ListTables()
  {

   string statusMessage = String.Empty;

  
    try
    {

     WindowsAzureStorageHelper storageHelper = new WindowsAzureStorageHelper();
    lbListTables.DataSource = storageHelper.ListTables();
    lbListTables.DataBind();
   

    }
    catch (DataServiceRequestException ex)
    {
     statusMessage = "Unable to connect to the table storage server. Please check that the service is running.<br>"
                     + ex.Message;
    }
  
   lblStatus.Text = statusMessage;

  }

  protected void ListBox1_SelectedIndexChanged(object sender, EventArgs e)
  {
   txtDeleteTable.Text = lbListTables.SelectedItem.Text;
  }

  protected void lbCreateProAzureTable_Click(object sender, EventArgs e)
  {
   CreateProAzureTable();
  }

  protected void lbDeleteProAzureTable_Click(object sender, EventArgs e)
  {
   DeleteProAzureTable();
  }
 }
}
